<?php

namespace App\Http\Controllers;

use App\Currency;
use App\ExchangeMoney;
use App\Jobs\SendSubsEmail;
use App\Subscriber;
use App\Trx;
use Illuminate\Http\Request;
use Auth;
use App\GeneralSettings;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Input;

use Validator;

class DashboardController extends Controller
{
    public function __construct()
    {

    }

    public function manageSubscribers()
    {
        $data['page_title'] = 'Subscribers';
        $data['events'] = Subscriber::latest()->paginate(30);
        return view('admin.pages.subscriber', $data);
    }

    public function updateSubscriber(Request $request)
    {
        $mac = Subscriber::findOrFail($request->id);
        $mac['status'] = $request->status;
        $res = $mac->save();

        if ($res) {
            return back()->with('success', ' Updated Successfully!');
        } else {
            return back()->with('alert', 'Problem With Updating ');
        }
    }

    public function sendMail()
    {
            $data['page_title'] = 'Mail to Subscribers';
            return view('admin.pages.subscriber-email', $data);
    }

    public function sendMailsubscriber(Request $request)
    {
        $this->validate($request,
            [
                'subject' => 'required',
                'message' => 'required'
            ]);

        $subject = $request->subject;
        $message = $request->message;


        $success = SendSubsEmail::dispatch($subject, $message)->delay(Carbon::now()->addSeconds(5));

        if($success){
            $notification = array('message' => 'Mail Sent Successfully!', 'alert-type' => 'success');
        }else{
            $notification = array('message' => 'Something Wrong!', 'alert-type' => 'error');
        }
        return back()->with($notification);
    }


    public function exchange()
    {
        $exchange = ExchangeMoney::latest()->where('status', 1)->paginate(20);
        $page_title = "Exchange Request";
        return view('admin.exchange.requests', compact('exchange', 'page_title'));
    }

    public function exchangeApprove()
    {
        $exchange = ExchangeMoney::latest()->where('status', 2)->paginate(20);
        $page_title = "Exchange Approved";
        return view('admin.exchange.history', compact('exchange', 'page_title'));
    }

    public function exchangeCancel()
    {
        $exchange = ExchangeMoney::latest()->where('status', -1)->paginate(20);
        $page_title = "Exchange Cancel";
        return view('admin.exchange.history', compact('exchange', 'page_title'));
    }
    public function exchangeRefund()
    {
        $exchange = ExchangeMoney::latest()->where('status', -2)->paginate(20);
        $page_title = "Exchange Refunded";
        return view('admin.exchange.history', compact('exchange', 'page_title'));
    }

    public function exchangeDetails($id)
    {
        $page_title = "Exchange Details";
        $pending_exchanges = ExchangeMoney::findOrFail($id);
        return view('admin.exchange.details', compact('pending_exchanges','page_title'));
    }

    public function approve(Request $request, $id)
    {
        $this->validate($request, [
            'admin_transaction_number' => 'required'
        ]);
        $basic = GeneralSettings::first();
        $withdr = ExchangeMoney::findorFail($id);
        $withdr['admin_transaction_number'] = $request->admin_transaction_number;
        $withdr['status'] = 2;
        $withdr->save();

        $notification = array('message' => 'Request Approved Successfully!', 'alert-type' => 'success');
        return back()->with($notification);
    }


    public function cancelExchange(Request $request)
    {

        $this->validate($request, [
            'reason' => 'required'
        ]);

        $exchange = ExchangeMoney::findOrFail($request->id);
        if($exchange->status == 1)
        {
            $exchange->cancel_reason =  $request->reason;
            $exchange->status =  -1;
            $exchange->update();

            $msg = $request->reason;
            send_email($exchange->customer_email, $exchange->user->username, 'Exchange cancelled Notification', $msg);

            $notification = array('message' => 'Order is cancelled successfully!', 'alert-type' => 'success');
            return back()->with($notification);
        }
        abort(404);
    }
    public function successExchange(Request $request)
    {
        $this->validate($request, [
            'admin_transaction_number' => 'required'
        ]);

        $basic =  GeneralSettings::first();

        $exchange = ExchangeMoney::findOrFail($request->id);



        if($exchange->status == 1)
        {
            $currency =  Currency::findOrFail($exchange->receive_method->id);

            $currency->reserve_amount = round(($currency->reserve_amount-$exchange->receive_amount), $basic->decimal);
            $currency->save();

            $exchange->admin_transaction_number =  $request->admin_transaction_number;
            $exchange->status =  2;
            $exchange->update();


            $msg = 'We have sent Money . Here is transaction number:  '.$request->admin_transaction_number;
            send_email($exchange->customer_email, $exchange->user->username, 'Exchange Success Notification', $msg);

            $notification = array('message' => 'Order is exchanged successfully!', 'alert-type' => 'success');
            return back()->with($notification);
        }
      abort(404);
    }


    public function  refundExchange(Request $request)
    {
        $this->validate($request, [
            'refund_reason' => 'required',
            'refund_balance' => 'required|numeric|min:0'
        ]);

        $basic =  GeneralSettings::first();
        $exchange = ExchangeMoney::findOrFail($request->id);
        if($exchange->status == 1)
        {

            $user = User::find($exchange->user_id);
            $user->balance =  round(($user->balance+ $request->refund_balance), $basic->decimal);
            $user->save();

            $exchange->status = -2;
            $exchange->refund_reason = $request->refund_reason;
            $exchange->refunded_money = round($request->refund_balance,2);
            $exchange->update();


            Trx::create([
                'user_id' => $user->id,
                'amount' => round($request->refund_balance,2),
                'main_amo' => round($user->balance,$basic->decimal),
                'charge' => 0,
                'type' => '+',
                'title' => round($request->refund_balance,2) . " $basic->currency Refunded ",
                'trx' => $exchange->trx,
            ]);


            $msg = round($request->refund_balance,2) . " $basic->currency Refunded. ";
            $msg .= $request->refund_reason;
            send_email($exchange->customer_email, $exchange->user->username, 'Exchange Refund Notification', $msg);


            $notification = array('message' => 'Exchange Money Refunded successfully!', 'alert-type' => 'success');
            return back()->with($notification);


        }
        abort(404);
    }

}
